/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeetingSite.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "ObjCHelpers.h"
#import "ObjcWrapperCache.h"
#import "CSISecureString.h"
#import <Foundation/NSDate.h>
#import "ObjectFoundry.h"
#import <objc/runtime.h>

#import "JCFUnifiedBusinessObject.h"
#import "JCFMeetingSite.h"

//cpp interface
#include "csfunified/services/interface/MeetingSite.h" 



NSString * const JCFMeetingSiteSiteUrlDidChangeNotification = @"JCFMeetingSiteSiteUrlDidChangeNotification";
NSString * const JCFMeetingSiteSiteDescriptionDidChangeNotification = @"JCFMeetingSiteSiteDescriptionDidChangeNotification";
NSString * const JCFMeetingSiteUserNameDidChangeNotification = @"JCFMeetingSiteUserNameDidChangeNotification";
NSString * const JCFMeetingSitePasswordDidChangeNotification = @"JCFMeetingSitePasswordDidChangeNotification";
NSString * const JCFMeetingSiteEditableFlagDidChangeNotification = @"JCFMeetingSiteEditableFlagDidChangeNotification";
NSString * const JCFMeetingSiteDeletableFlagDidChangeNotification = @"JCFMeetingSiteDeletableFlagDidChangeNotification";
NSString * const JCFMeetingSiteDefaultSiteFlagDidChangeNotification = @"JCFMeetingSiteDefaultSiteFlagDidChangeNotification";
NSString * const JCFMeetingSiteActiveFlagDidChangeNotification = @"JCFMeetingSiteActiveFlagDidChangeNotification";
NSString * const JCFMeetingSiteSiteFlagDidChangeNotification = @"JCFMeetingSiteSiteFlagDidChangeNotification";
NSString * const JCFMeetingSiteSSOFlagDidChangeNotification = @"JCFMeetingSiteSSOFlagDidChangeNotification";

#include <map>

typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSite> MeetingSitePtr;
typedef SMART_PTR_NS::shared_ptr<CSFUnified::MeetingSiteObserver> MeetingSiteObserverPtr;

typedef SMART_PTR_NS::weak_ptr<CSFUnified::MeetingSite> MeetingSiteWPtr;
typedef std::owner_less<MeetingSiteWPtr> wp_less;
typedef std::map<MeetingSiteWPtr, JCFMeetingSite*, wp_less> MeetingSiteCache;
static MeetingSiteCache sCache;

@interface JCFMeetingSite ()

@property (nonatomic, readwrite, assign) struct MeetingSiteOpaque *cpp;

-(id)initWithMeetingSitePtr:(MeetingSitePtr)meetingSite;

@end

#include "JCFMeetingSiteObserver.h"

struct MeetingSiteOpaque
{
	
	MeetingSiteOpaque(JCFMeetingSite* ObjcOwner, MeetingSitePtr meetingSite) 
	:mMeetingSite(meetingSite),
	mMeetingSiteObserver(new JCFMeetingSiteObserver(ObjcOwner))
	{
		mMeetingSite->addObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingSiteObserver>(mMeetingSiteObserver));
	};
	
	~MeetingSiteOpaque() 
	{
		mMeetingSite->removeObserver(SMART_PTR_NS::weak_ptr<CSFUnified::MeetingSiteObserver>(mMeetingSiteObserver));
	};
	
	MeetingSitePtr mMeetingSite;
	
private:
	MeetingSiteObserverPtr mMeetingSiteObserver;
};

@implementation JCFMeetingSite

@synthesize cpp = mMeetingSiteCpp;

#pragma mark Base Unified Business Object Properties





-(NSString*) siteUrl
{
	
    std::string stringCpp = self.cpp->mMeetingSite->getSiteUrl();
	return JCFNSStringForStdString(stringCpp);
	}


-(NSString*) siteDescription
{
	
    std::string stringCpp = self.cpp->mMeetingSite->getSiteDescription();
	return JCFNSStringForStdString(stringCpp);
	}


-(NSString*) userName
{
	
    std::string stringCpp = self.cpp->mMeetingSite->getUserName();
	return JCFNSStringForStdString(stringCpp);
	}


-(CSISecureString*) password
{
	
    csf::SecureString stringCpp = self.cpp->mMeetingSite->getPassword();
	return CSISecureStringForSecureString(stringCpp);
	}


-(BOOL) editableFlag
{
    return self.cpp->mMeetingSite->getEditableFlag();
}


-(BOOL) deletableFlag
{
    return self.cpp->mMeetingSite->getDeletableFlag();
}


-(BOOL) defaultSiteFlag
{
    return self.cpp->mMeetingSite->getDefaultSiteFlag();
}


-(BOOL) activeFlag
{
    return self.cpp->mMeetingSite->getActiveFlag();
}


-(int) siteFlag
{
    return self.cpp->mMeetingSite->getSiteFlag();
}


-(int) sSOFlag
{
    return self.cpp->mMeetingSite->getSSOFlag();
}




#pragma mark Constructors

-(JCFMeetingSite*) initWithMeetingSitePtr:(MeetingSitePtr)meetingSite
{
	@synchronized([self class])
	{
		MeetingSiteWPtr wp(meetingSite);
		MeetingSiteCache::const_iterator iter = sCache.find(wp);
		if (iter != sCache.end())
		{
			[self release];
			self = [(*iter).second retain];
		}
		else
		{
			self = [super initSuperWithUnifiedBusinessObjectPtr : meetingSite];
			if (self != nil)
			{
				if ([self class] == [JCFMeetingSite class])
				{
					if (meetingSite != NULL)
					{
						self.cpp = new MeetingSiteOpaque(self, meetingSite);
						sCache[wp] = self;
					}
					else
					{
						[self release];
						self = nil;
					}
				}
			}
		}
	}

	return self;
}

-(JCFMeetingSite*) initSuperWithMeetingSitePtr:(MeetingSitePtr)meetingSite
{
	self = [super initSuperWithUnifiedBusinessObjectPtr : meetingSite];

	if (self != nil)
	{
		if ([self class] == [JCFMeetingSite class])
		{
			if (meetingSite == NULL)
			{
				[self release];
				self = nil;
			}
		}
	}
	return self;
}

-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr
{
	MeetingSitePtr meetingSite = SMART_PTR_NS::dynamic_pointer_cast<CSFUnified::MeetingSite>(cppPtr);
	self = [self initWithMeetingSitePtr: meetingSite ];
	return self;
}

-(JCFMeetingSite*) init
{
    NSAssert(NO, @"init with initWithMeetingSitePtr:");
    [self release];
    self = nil;
	return nil;
}

+ (BOOL)automaticallyNotifiesObserversForKey:(NSString *)theKey {
	
	if([theKey isEqualToString:@"siteUrl"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"siteDescription"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"userName"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"password"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"editableFlag"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"deletableFlag"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"defaultSiteFlag"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"activeFlag"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"siteFlag"])
	{
		return NO;
	}
	if([theKey isEqualToString:@"sSOFlag"])
	{
		return NO;
	}
	return [super automaticallyNotifiesObserversForKey:theKey];
}

+ (BOOL)accessInstanceVariablesDirectly
{
	return NO;
}

- (void)willChangeValueForKey:(NSString *)key
{
	kvoUpdate = YES;

	[super willChangeValueForKey:key];
}

- (void)didChangeValueForKey:(NSString *)key
{
	kvoUpdate = NO;
	[super didChangeValueForKey:key];
}

- (void)addObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context
{
	
	if([keyPath hasPrefix:@"siteUrl"])
	{
		objc_setAssociatedObject(observer, &mSiteUrl, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"siteDescription"])
	{
		objc_setAssociatedObject(observer, &mSiteDescription, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"userName"])
	{
		objc_setAssociatedObject(observer, &mUserName, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"password"])
	{
		objc_setAssociatedObject(observer, &mPassword, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"editableFlag"])
	{
		objc_setAssociatedObject(observer, &mEditableFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"deletableFlag"])
	{
		objc_setAssociatedObject(observer, &mDeletableFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"defaultSiteFlag"])
	{
		objc_setAssociatedObject(observer, &mDefaultSiteFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"activeFlag"])
	{
		objc_setAssociatedObject(observer, &mActiveFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"siteFlag"])
	{
		objc_setAssociatedObject(observer, &mSiteFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}
	if([keyPath hasPrefix:@"sSOFlag"])
	{
		objc_setAssociatedObject(observer, &mSSOFlag, self, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		[super addObserver:observer forKeyPath:keyPath options:options context:context];
		return;
	}

	[super addObserver:observer forKeyPath:keyPath options:options context:context];
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath context:(void *)context
{
	[super removeObserver:observer forKeyPath:keyPath context:context];

	
	if([keyPath hasPrefix:@"siteUrl"])
	{
		objc_setAssociatedObject(observer, &mSiteUrl, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"siteDescription"])
	{
		objc_setAssociatedObject(observer, &mSiteDescription, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"userName"])
	{
		objc_setAssociatedObject(observer, &mUserName, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"password"])
	{
		objc_setAssociatedObject(observer, &mPassword, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"editableFlag"])
	{
		objc_setAssociatedObject(observer, &mEditableFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"deletableFlag"])
	{
		objc_setAssociatedObject(observer, &mDeletableFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"defaultSiteFlag"])
	{
		objc_setAssociatedObject(observer, &mDefaultSiteFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"activeFlag"])
	{
		objc_setAssociatedObject(observer, &mActiveFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"siteFlag"])
	{
		objc_setAssociatedObject(observer, &mSiteFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"sSOFlag"])
	{
		objc_setAssociatedObject(observer, &mSSOFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

- (void)removeObserver:(NSObject *)observer forKeyPath:(NSString *)keyPath
{
	[super removeObserver:observer forKeyPath:keyPath];

	
	if([keyPath hasPrefix:@"siteUrl"])
	{
		objc_setAssociatedObject(observer, &mSiteUrl, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"siteDescription"])
	{
		objc_setAssociatedObject(observer, &mSiteDescription, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"userName"])
	{
		objc_setAssociatedObject(observer, &mUserName, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"password"])
	{
		objc_setAssociatedObject(observer, &mPassword, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"editableFlag"])
	{
		objc_setAssociatedObject(observer, &mEditableFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"deletableFlag"])
	{
		objc_setAssociatedObject(observer, &mDeletableFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"defaultSiteFlag"])
	{
		objc_setAssociatedObject(observer, &mDefaultSiteFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"activeFlag"])
	{
		objc_setAssociatedObject(observer, &mActiveFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"siteFlag"])
	{
		objc_setAssociatedObject(observer, &mSiteFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
	if([keyPath hasPrefix:@"sSOFlag"])
	{
		objc_setAssociatedObject(observer, &mSSOFlag, nil, OBJC_ASSOCIATION_RETAIN_NONATOMIC);
		return;
	}
}

-(void)dealloc
{
	@synchronized([self class])
	{
		if (self.cpp != NULL)
		{
			MeetingSiteWPtr wp(self.cpp->mMeetingSite);
			sCache.erase(wp);

	  		delete self.cpp;
  			self.cpp = NULL;
	  	}
	}

  	[super dealloc];
}

-(MeetingSitePtr) getMeetingSitePtr
{
	return self.cpp->mMeetingSite;
}



@end